/*
 *  Tutorial A - sceanraio
 *
 *  tested with 112.4.0 nightly r7096, pak64 r1409
 *  Can NOT be used in network game !
 */

const version = 0002				// version of script
map.file = "tutorial.sve"			// specify the savegame to load
scenario_name             <- "Tutorial A"
scenario.short_description = scenario_name
scenario.author            = "ny911"
scenario.version           = (version / 1000) + "." + ((version % 1000) / 100) + "." + (version % 100)
scenario.translation      <- "n.n."

persistent.version <- version			// stores version of script
persistent.select  <- null			// stores user selection
persistent.chapter <- 1				// stores chapter number
chapter            <- null			// used later for class
select_option      <- { x = 1, y = 1, z = -1 }	// place of station to control name
select_option_halt <- null			// placeholder for halt_x
tutorial		  <- {}				// placeholder for all chapter CLASS
factory_list       <-
{
	sawmill		= { x = 57, y = 101 }
	furniture_store	= { x = 80, y =  89 }
	furniture_fact	= { x = 44, y = 118 }
}
good_alias         <-				// placeholder for good names in pak64
{
	wood		= "Holz",
	planks		= "Bretter",
	furniture	= "Moebel"
}



class basic_chapter
{        // chapter description : this is a placeholder
         constructor(pl)
         {
         	scenario.short_description = scenario_name + " - " + ttext(this.chapter_name)
		this.set_all_rules(pl)
         }
	chapter_name	= ""		// placeoder for shapter name
	step		= 1		// count the step inside the chapter 1=A
	startcash	= 0		// pl=0 startchash; 0=no reset
         function get_rule_text(pl,path)
         {
	        local text = ttextfile( path + "rule.txt" )
                 return text.tostring()
         }
         function get_goal_text(pl,path)
         {
	        local text = ttextfile( path + "goal.txt" )
                 return text.tostring()
         }
         function is_chapter_completed(pl)
         {
                 local percentage = 0
                 return percentage
         }
	function is_work_allowed_here(pl, tool_id, pos)
	{
         	local result = null	// null is equivalent to 'allowed'
         	return result
	}
	function is_schedule_allowed(pl, schedule)
	{
         	local result = null	// null is equivalent to 'allowed'
         	return result
	}
         function set_all_rules(pl)	// set all fordbid ruls and tools
         {
	}
	// BASIC FUNCTIONS
         function next_step()
	{
		this.step++
		// make here screen refresh
		return null		// null is equivalent to 'allowed'
	}
	function my_step(i)
	{
		return "step_" + ( i < 10 ? "0":"" ) + i
	}
	function has_way(waytyp,rect)
	{
		local res = true
		for (local x = rect[0]; x <= rect[2]; x++)
			for (local y = rect[1]; y <= rect[3]; y++)
			 	if (square_x(x,y).get_ground_tile().has_way(waytyp) == false)
					res = false
		return res
	}
	function give_ttext(text,cord)		// cord may be: table {x,y} or array[0,1,2,3]
	{
                 local result = ttext(text)
		local modus = true
		try { cord.x } catch(cord) { modus = false }
		if (modus)
			result.pos  = "("+cord.x+","+cord.y+")"
		else	result.rect = "("+cord[0]+","+cord[1]+" - "+cord[2]+","+cord[3]+")"
		return result.tostring()
	}
	function give_title()
	{
		return "<em>"+ttext("Chapter")+" "+persistent.chapter+"</em> - "+ttext(this.chapter_name)+"<br><br>"
	}
}



class tutorial.chapter_01 extends basic_chapter
{
	chapter_name  = "First Train"	// name, not too long
	startcash     = 500000		// pl=0 startchash; 0=no reset
	// privat
	target = 168			// target amount of wood
	rect_a = [41,100,56,100]	// area for rail track
	rect_b = [50,97,50,100]		// area for rail track to build depot
	rect_c = [41,97,56,100]		// big area for rail track
	depot  = {x = 50, y = 97}
	treedel= {x = 50, y = 100}	// place to cut down all trees
	halt_a = {x = 42, y = 100}	// station area
	halt_b = {x = 55, y = 100}	// station area

         function get_rule_text(pl,path)
         {
	        local text = ttextfile( path + "rule.txt" )
                 return text.tostring()
         }
         function get_goal_text(pl,path)
         {
	        local text = ttextfile( path + "goal.txt" )
		local text_step = ttextfile( path + "goal_" + this.my_step(this.step) + ".txt" )
		for (local i = 1; i <= 8; i++)
			text[this.my_step(i)] = ""
         	switch(this.step)	// set placeholder for each step
         	{
         		case 1: text_step.pos_tree = "("+treedel.x+","+treedel.y+")"
				break
         		case 2: text_step.rect_a = "("+rect_a[0]+","+rect_a[1]+" - "+rect_a[2]+","+rect_a[3]+")"
				break
         		case 3: text_step.rect_b = "("+rect_b[0]+","+rect_b[1]+" - "+rect_b[2]+","+rect_b[3]+")"
				break
         		case 4: text_step.halt = "("+halt_a.x+","+halt_a.y+")"
				break
         		case 5: text_step.halt = "("+halt_b.x+","+halt_b.y+")"
				break
         		case 6: text_step.depot = "("+depot.x+","+depot.y+")"
				break
         		case 8: text_step.target = this.target
				break
		}
		text[my_step(this.step)] = text_step.tostring()
                 return text.tostring()
         }
         function is_chapter_completed(pl)
         {
                 local percentage = 0
		local factory = factory_x(factory_list.sawmill.x, factory_list.sawmill.y)
		local amount = factory.input[good_alias.wood].get_received().reduce(sum)
		percentage = min( (amount * 100 / this.target), 100)
                 if ( (this.step == 2) && this.has_way(wt_rail,rect_a) ) this.next_step()
                 if ( (this.step == 3) && this.has_way(wt_rail,rect_b) ) this.next_step()
                 return percentage
         }
	function is_work_allowed_here(pl, tool_id, pos)
	{
         	local result = null	// null is equivalent to 'allowed'
		result = ttext("Action not allowed")  // set standard error message
                 switch (this.step)
		{
			case 1: if ( (tool_id != tool_remover) || (pos.x != treedel.x) || (pos.y != treedel.y) )
                                      result = this.give_ttext("Pleace cut down tree at {pos}",treedel)
                                 else result = this.next_step()
				break
			case 2: if ( (tool_id != tool_build_way) ||( (pos.x < rect_a[0]) || (pos.y < rect_a[1]) || (pos.x > rect_a[2]) || (pos.y > rect_a[3])) )
                                      result = this.give_ttext("Pleace build railway inside {rect}",rect_a)
                                 else result = null	// no next step here
				break
			case 3: if ( (tool_id != tool_build_way) ||( (pos.x < rect_b[0]) || (pos.y < rect_b[1]) || (pos.x > rect_b[2]) || (pos.y > rect_b[3])) )
				     result = this.give_ttext("Pleace build railway inside {rect}",rect_b)
                                 else result = null	// no next step here
				break
			case 4: if ( (tool_id != tool_build_station) || (pos.x != halt_a.x) || (pos.y != halt_a.y) )
				     result = this.give_ttext("Pleace build a station at {pos}",halt_a)
				else result = this.next_step()
				break
			case 5: if ( (tool_id != tool_build_station) || (pos.x != halt_b.x) || (pos.y != halt_b.y) )
				     result = this.give_ttext("Pleace build a station at {pos}",halt_b)
				else result = this.next_step()
				break
			case 6: if ( (tool_id != tool_build_depot) || (pos.x != depot.x) || (pos.y != depot.y) )
				     result = this.ttext("Pleace build the rail depot at {pos}",depot)
				else result = this.next_step()
				break
			default:result = null
		}
		if (tool_id == 4096) result = null	// it's the standard tool; allow it allways
		if ( (this.step > 3) && (tool_id == tool_build_way) )
			if (!( (pos.x < rect_c[0]) || (pos.y < rect_c[1]) || (pos.x > rect_c[2]) || (pos.y > rect_c[3]) ) )
				result = null		// allow late track correction
                 return result
	}
	function is_schedule_allowed(pl, schedule)
	{
         	local result = null	// null is equivalent to 'allowed'
		if ( (pl == 0) && (schedule.waytype != wt_rail) )
			result = ttext("Only railway schedules allowed")
		if ( (pl == 0) && (this.step < 8) && (schedule.entries.len() > 2) )
			result = ttext("Only two waystops for this schedule.")
		if ( (result == null) && (this.step == 7) ) this.next_step()
         	return result
	}
         function set_all_rules(pl)	// set all fordbid ruls and tools
         {
		local forbid = [tool_build_way,tool_build_bridge,tool_build_tunnel,tool_build_station,tool_remove_way,tool_build_depot,tool_build_roadsign,tool_build_wayobj]
		foreach(wt in all_waytypes)
			if (wt != wt_rail)
			{
				foreach (tool_id in forbid)
					rules.forbid_way_tool(pl, tool_id, wt )
			}
		local forbid = [tool_build_wayobj,tool_build_tunnel,tool_build_bridge,tool_build_roadsign]
		foreach (tool_id in forbid)
			rules.forbid_way_tool(pl, tool_id, wt_rail )
		local forbid = [tool_lower_land,tool_raise_land,tool_setslope,tool_restoreslope,tool_make_stop_public,tool_build_transformer]
		foreach (tool_id in forbid)
			rules.forbid_tool(pl, tool_id )
	}
}        // END of class


class tutorial.chapter_02 extends basic_chapter
{
	chapter_name  = "Two Trains"	// name, not too long
	startcash     = 0		// pl=0 startchash; 0=no reset
	// privat
	target = 756			// target amount of planks
	rect_a = [56,100,79,100]	// area for rail track
	rect_b = [79,90,79,100]		// area for rail track to build depot
	rect_c = [41,97,79,100]		// big area for rail track
	depot  = {x = 50, y = 97}
	treedel= {x = 50, y = 100}	// place to cut down all trees
	halt_a2 = {x = 41, y = 100}	// station area
	halt_b2 = {x = 56, y = 100}	// station area
	halt_c1 = {x = 79, y = 91}	// station area
	halt_c2 = {x = 79, y = 92}	// station area

         function get_rule_text(pl,path)
         {
	        local text = ttextfile( path + "rule.txt" )
                 return text.tostring()
         }
         function get_goal_text(pl,path)
         {
	        local text = ttextfile( path + "goal.txt" )
		local text_step = ttextfile( path + "goal_" + this.my_step(this.step) + ".txt" )
		for (local i = 1; i <= 8; i++)
			text[this.my_step(i)] = ""
         	switch(this.step)	// set placeholder for each step
         	{
         		case 2: text_step.rect_a = "("+rect_a[0]+","+rect_a[1]+" - "+rect_a[2]+","+rect_a[3]+")"
				break
         		case 3: text_step.rect_a = "("+rect_b[0]+","+rect_b[1]+" - "+rect_b[2]+","+rect_b[3]+")"
				break
         		case 8: text_step.target = this.target
				break
		}
		text[my_step(this.step)] = text_step.tostring()
                 return text.tostring()
         }
         function is_chapter_completed(pl)
         {
                 local percentage = 0
		local factory = factory_x(factory_list.furniture_store.x, factory_list.furniture_store.y)
		local amount = factory.input[good_alias.planks].get_received().reduce(sum)
		local r1 = [79,98,79,100]
		local r2 = [79,90,79,93]
		percentage = min( ( amount * 100 / this.target), 100)
                 if ( (this.step == 1) && this.has_way(wt_rail,rect_a) ) this.next_step()
                 if ( (this.step == 2) && this.has_way(wt_rail,r1) && this.has_way(wt_rail,r2) &&
		     (square_x(79,93).get_ground_tile().is_bridge() == true) ) this.next_step()
                 return percentage
         }
	function is_work_allowed_here(pl, tool_id, pos)
	{
         	local result = null	// null is equivalent to 'allowed'
		result = ttext("Action not allowed")  // set standard error message
                 switch (this.step)
		{
			case 1: if ( (tool_id != tool_build_way) || ( (pos.x < rect_a[0]) || (pos.y < rect_a[1]) || (pos.x > rect_a[2]) || (pos.y > rect_a[3])) )
                                      result = this.give_ttext("Pleace build railway inside {rect}",rect_a)
                                 else result = null	// no next step here
				break
			case 2: if ( ( (tool_id != tool_build_way) && (tool_id != tool_build_bridge) )
			             || ( (pos.x < rect_b[0]) || (pos.y < rect_b[1]) || (pos.x > rect_b[2]) || (pos.y > rect_b[3])) )
				     result = this.give_ttext("Pleace build railway inside {rect}",rect_b)
                                 else result = null	// no next step here
				break
			case 3: if ( (tool_id != tool_build_station) ||
				     ((pos.x != halt_c1.x) && (pos.x != halt_c2.x)) ||
				     ((pos.y != halt_c1.y) && (pos.y != halt_c2.y)) )
				     result = this.give_ttext("Pleace build a station at {pos}",halt_c1)
				else result = this.next_step()
				break
			case 5: if ( (tool_id != tool_build_station) || (pos.x != halt_b.x) || (pos.y != halt_b.y) )
				     result = this.give_ttext("Pleace build a station at {pos}",halt_b)
				else result = this.next_step()
				break
			case 6: if ( (tool_id != tool_build_depot) || (pos.x != depot.x) || (pos.y != depot.y) )
				     result = this.ttext("Pleace build the rail depot at {pos}",depot)
				else result = this.next_step()
				break
			default:result = null
		}
		if (tool_id == 4096) result = null	// it's the standard tool; allow it allways
		if ( (this.step > 3) && (tool_id == tool_build_way) )
			if (!( (pos.x < rect_c[0]) || (pos.y < rect_c[1]) || (pos.x > rect_c[2]) || (pos.y > rect_c[3]) ) )
				result = null		// allow late track correction
                 return result
	}
	function is_schedule_allowed(pl, schedule)
	{
         	local result = null	// null is equivalent to 'allowed'
		if ( (pl == 0) && (schedule.waytype != wt_rail) )
			result = ttext("Only railway schedules allowed")
		if ( (pl == 0) && (this.step < 8) && (schedule.entries.len() > 2) )
			result = ttext("Only two waystops for this schedule.")
		if ( (result == null) && (this.step == 7) ) this.next_step()
         	return result
	}
         function set_all_rules(pl)	// set all fordbid ruls and tools
         {
		local forbid = [tool_build_way,tool_build_bridge,tool_build_tunnel,tool_build_station,tool_remove_way,tool_build_depot,tool_build_roadsign,tool_build_wayobj]
		foreach(wt in all_waytypes)
			if (wt != wt_rail)
			{
				foreach (tool_id in forbid)
					rules.forbid_way_tool(pl, tool_id, wt )
			}
		local forbid = [tool_build_wayobj,tool_build_tunnel,tool_build_roadsign]
		// not in forbid_list : tool_build_bridge,
		foreach (tool_id in forbid)
			rules.forbid_way_tool(pl, tool_id, wt_rail )
		local forbid = [tool_lower_land,tool_raise_land,tool_setslope,tool_restoreslope,tool_make_stop_public,tool_build_transformer]
		foreach (tool_id in forbid)
			rules.forbid_tool(pl, tool_id )
	}
}        // END of class



class tutorial.chapter_03 extends basic_chapter
{
	chapter_name = "empty chapter"
	// emtpy, nothing to extend
}        // END of class




//
// main part of the script
//

chapter            <- tutorial.chapter_01		// must be placed here !!!


function is_numeric(string)
{
	try { string.tointeger() }
	catch(string) { return false }
	return true
}


function sum(a,b)
{
	return a+b
}


function my_chapter()
{
         return "chapter_"+(persistent.chapter < 10 ? "0":"")+persistent.chapter+"/"
}


function scenario_percentage(percentage)
{
	return min( ((persistent.chapter - 1) * 100 + percentage) / tutorial.len(), 100 )
}


function load_chapter(number,pl)
{
         rules.clear()
	if (number <= tutorial.len() )		// replace the class
		chapter <- tutorial["chapter_"+(number < 10 ? "0":"")+number](pl)
	else    persistent.chapter--
	if ( (number == persistent.chapter) && (chapter.startcash > 0) )
		player_x(0).book_cash( (chapter.startcash - player_x(0).get_cash()[0]) * 100)
}


function set_city_names()
{
	foreach ( city in city_list_x() )
	{
		local name = ttext( city.get_name() )
		if (name.tostring() != "") city.set_name( name.tostring() )
	}
}


function get_info_text(pl)
{
         local info = ttextfile("info.txt")
	local help = ""
	local i = 0
	foreach (chap in tutorial)
		help+= "<em>"+ttext("Chapter")+" "+(++i)+"</em> - "+ttext(chap.chapter_name)+"<br>"
	info.list_of_chapters = help
	help = "<a href=\"("+select_option.x+","+select_option.y+")\">"
	help+= "("+select_option.x+","+select_option.y+","+select_option.z+")"
	help+= "</a>"
	info.select_option = help
	info.first_link = "<a href=\"goal\">"+(persistent.chapter <= 1 ? ttext("Let's start!"):ttext("Let's go on!") )+"</a>"
         return info
}


function get_rule_text(pl)
{
         return chapter.give_title() + chapter.get_rule_text( pl, my_chapter() )
}


function get_goal_text(pl)
{
         return chapter.give_title() + chapter.get_goal_text( pl, my_chapter() )
}


function get_result_text(pl)
{
	local text = ttextfile("result.txt")
	local percentage = chapter.is_chapter_completed(pl)
	text.ratio_chapter = percentage
	text.ratio_scenario = scenario_percentage(percentage)
         return chapter.give_title() + text.tostring()
}


function get_about_text(pl)
{
         local about = ttextfile("about.txt")
         about.short_description = scenario_name
         about.version = scenario.version
         about.author = scenario.author
         about.translation = scenario.translation
         return about
}


function start()
{
	set_city_names()
         resume_game()
}


function is_scenario_completed(pl)
{
	if (pl != 0) return 0			// other player get only 0%
	if (is_numeric(select_option_halt.get_name()) &&
	    (select_option_halt.get_name() != persistent.select) )
	{                                       // change chapter
		persistent.select = select_option_halt.get_name()
		persistent.chapter = persistent.select.tointeger()
		load_chapter( persistent.chapter, pl )
         	// ############## need update of scenario window
	}
	local percentage = chapter.is_chapter_completed(pl)
	if ( percentage == 100 )		// give message
         {
		local text = ttext("Chapter {number} complete.")
		text.number = persistent.chapter
		gui.add_message( text.tostring() )
		persistent.chapter++
		load_chapter( persistent.chapter, pl )
		percentage = chapter.is_chapter_completed(pl)
         	// ############## need update of scenario window
         }
	percentage = scenario_percentage(percentage)
         if ( percentage == 100 )		// scenario complete
	{
		local text = ttext("Tutorial Scenario complete.")
		gui.add_message( text.tostring() )
	}
         return percentage
}


function is_work_allowed_here(pl, tool_id, pos)
{
        	if (pl != 0) return null
         return chapter.is_work_allowed_here(pl, tool_id, pos)
}


function is_schedule_allowed(pl, schedule)
{
        	if (pl != 0) return null
	return chapter.is_schedule_allowed(pl, schedule)
}


function resume_game()
{
         // check for script version and compatibility, then use update
         if ( persistent.version < version )
              update()				// do update old versions
         else gui.open_info_win()		// show scenario window
         load_chapter(persistent.chapter,0)      // load correct chapter for player=0
	select_option_halt = tile_x( select_option.x, select_option.y, select_option.z ).get_halt()
	persistent.select = select_option_halt.get_name()
	// correct settings of savegame
         settings.set_industry_increase_every(0)
}


function update()                // update for older versions
{
         local text = ttext("Savegame has a different {more_info} script version! Maybe, it will work.")
         text.more_info = "(" + (version / 1000) + "." + ((version % 1000) / 100) + "." + (version % 100) + ")"
         gui.add_message( text.tostring() )
         // version 0.xxx
              // if (persistent.version <= 0) { }
         // DONE old versions
         persistent.version = version    // change the old version number
}

// END OF FILE



/* NOTES to include later

- loadfile() or include() extra NUT files
- scenario window refresh (three places in code)
- Text Notes in game
- control of correct ways
- Pause darf fr nchsten Schritt nicht aktiv sein !!!

   END NOTES */