/*
 *  Tutorial A - scenario
 *
 *  tested with 120.0.1 nightly r7356, pak64
 *  Can NOT be used in network game !
 */

const version = 103				// version of script
map.file = "tutorial.sve"			// specify the savegame to load
scenario_name             <- "Tutorial A"
scenario.short_description = scenario_name
scenario.author            = "ny911"
scenario.version           = (version / 1000) + "." + ((version % 1000) / 100) + "." + ((version % 100) / 10) + (version % 10)
scenario.translation      <- "n.n."

const nut_path      = "class/"			// path to folder with *.nut files
persistent.version <- version			// stores version of script
persistent.select  <- null			// stores user selection
persistent.chapter <- 1				// stores chapter number
persistent.step    <- 1				// stores step number of chapter

chapter            <- null			// used later for class
chapter_max        <- 2				// amount of chapter
select_option      <- { x = 1, y = 1, z = -1 }	// place of station to control name
select_option_halt <- null			// placeholder for halt_x
tutorial		  <- {}				// placeholder for all chapter CLASS
factory_list       <-
{
	nutzwald	= { x = 38, y =  98 }   // use simutrans list is much better
	sawmill		= { x = 57, y = 101 }
	furniture_store	= { x = 80, y =  89 }
	furniture_fact	= { x = 44, y = 118 }
}
good_alias         <-				// placeholder for good names in pak64
{
	wood		= "Holz",
	planks		= "Bretter",
	furniture	= "Moebel"
}


include(nut_path+"class_basic_chapter") 		// include class for basic chapter structure
for (local i = 1; i <= chapter_max; i++)		// include amount of chapter classes
	include(nut_path+"class_chapter_"+(i < 10 ? "0"+i:i) )
chapter            <- tutorial.chapter_01      	// must be placed here !!!


function is_numeric(string)
{
	try { string.tointeger() }
	catch(string) { return false }
	return true
}


function sum(a,b)
{
	return a+b
}


function my_chapter()
{
         return "chapter_"+(persistent.chapter < 10 ? "0":"")+persistent.chapter+"/"
}


function scenario_percentage(percentage)
{
	return min( ((persistent.chapter - 1) * 100 + percentage) / tutorial.len(), 100 )
}


function load_chapter(number,pl)
{
         rules.clear()
	if (number <= tutorial.len() )		// replace the class
		chapter <- tutorial["chapter_"+(number < 10 ? "0":"")+number](pl)
	else    persistent.chapter--
	if ( (number == persistent.chapter) && (chapter.startcash > 0) )  // set cash money here
		player_x(0).book_cash( (chapter.startcash - player_x(0).get_cash()[0]) * 100)
}


function set_city_names()
{
	foreach ( city in city_list_x() )
	{
		local name = ttext( city.get_name() )
		if (name.tostring() != "") city.set_name( name.tostring() )
	}
}


function get_info_text(pl)
{
         local info = ttextfile("info.txt")
	local help = ""
	local i = 0
	foreach (chap in tutorial)
		help+= "<em>"+ttext("Chapter")+" "+(++i)+"</em> - "+ttext(chap.chapter_name)+"<br>"
	info.list_of_chapters = help
	help = "<a href=\"("+select_option.x+","+select_option.y+")\">"
	help+= "("+select_option.x+","+select_option.y+","+select_option.z+")"
	help+= "</a>"
	info.select_option = help
	info.first_link = "<a href=\"goal\">"+(persistent.chapter <= 1 ? ttext("Let's start!"):ttext("Let's go on!") )+"</a>"
         return info
}


function get_rule_text(pl)
{
         return chapter.give_title() + chapter.get_rule_text( pl, my_chapter() )
}


function get_goal_text(pl)
{
         return chapter.give_title() + chapter.get_goal_text( pl, my_chapter() )
}


function get_result_text(pl)
{
	local text = ttextfile("result.txt")
	local percentage = chapter.is_chapter_completed(pl)
	text.ratio_chapter = percentage
	text.ratio_scenario = scenario_percentage(percentage)
         return chapter.give_title() + text.tostring()
}


function get_about_text(pl)
{
         local about = ttextfile("about.txt")
         about.short_description = scenario_name
         about.version = scenario.version
         about.author = scenario.author
         about.translation = scenario.translation
         return about
}


function start()
{
	set_city_names()
         resume_game()
}


function is_scenario_completed(pl)
{
	if (pl != 0) return 0			// other player get only 0%
	if (is_numeric(select_option_halt.get_name()) &&
	    (select_option_halt.get_name() != persistent.select) )
	{                                       // change chapter
		persistent.select = select_option_halt.get_name()
		persistent.chapter = persistent.select.tointeger()
		load_chapter( persistent.chapter, pl )
         	// ############## need update of scenario window
	}
	local percentage = chapter.is_chapter_completed(pl)
	if ( percentage >= 100 )		// give message , be sure to have 100% or more
         {
		local text = ttext("Chapter {number} complete.")
		text.number = persistent.chapter
		gui.add_message( text.tostring() )
		persistent.chapter++
		load_chapter( persistent.chapter, pl )
		percentage = chapter.is_chapter_completed(pl)
         	// ############## need update of scenario window
         }
	percentage = scenario_percentage(percentage)
         if ( percentage >= 100 )		// scenario complete
	{
		local text = ttext("Tutorial Scenario complete.")
		gui.add_message( text.tostring() )
	}
         return percentage
}


function is_work_allowed_here(pl, tool_id, pos)
{
        	if (pl != 0) return null
         return chapter.is_work_allowed_here(pl, tool_id, pos)
}


function is_schedule_allowed(pl, schedule)
{
        	if (pl != 0) return null
	return chapter.is_schedule_allowed(pl, schedule)
}


function resume_game()
{
         // check for script version and compatibility, then use update
         if ( persistent.version < version )
              update()				// do update old versions
         load_chapter(persistent.chapter,0)      // load correct chapter for player=0
	chapter.step = persistent.step		// set chapter step from persistent
	select_option_halt = tile_x( select_option.x, select_option.y, select_option.z ).get_halt()
	persistent.select = select_option_halt.get_name()
         settings.set_industry_increase_every(0) // correct settings of savegame
        	gui.open_info_win()			// show scenario window
}


function update()                		// update for older versions
{
         local text = ttext("Savegame has a different {more_info} script version! Maybe, it will work.")
         text.more_info = "(" + (version / 1000) + "." + ((version % 1000) / 100) + "." + ((version % 100) / 10) + (version % 10) + ")"
         gui.add_message( text.tostring() )
         // version 0.xxx
              // if (persistent.version <= 0) { }
         // DONE old versions
         persistent.version = version    	// change the old version number
}

// END OF FILE