#!/bin/sh


# Information

echo "
=====SIMPLEPAK=====
This is a Shell-Script to create PAK Files with MakeObj.
You need makeobj and this Script in the same folder.
=====SIMPLEPAK=====
It's a BETA Version. Updates comming soon. Current Version: 0.1.2
May read the README.txt File for more Informations.
=====SIMPLEPAK=====
"


# Check: Is there makeobj? No? Bad!

while true
  do
    if [ -f makeobj ]
      then
        echo "Found makeobj"
        break
      else
        echo "ERROR: Please download makeobj for Linux!"
        exit 0
    fi
done


# Ask for Pak Size

while true
  do
    read -p "Choose one of these PAK sizes: 64, 96, 128, 192! Enter your PAK size:" pak
    case "$pak" in
        64) ./makeobj pak64
          echo "Created PAK64 Files with all .dat Files"
          break
          ;;
        96) ./makeobj pak96
          echo "Created PAK96 Files with all .dat Files"
          break
          ;;
        128) ./makeobj pak128
          echo "Created PAK128 Files with all .dat Files"
          break
          ;;
        192) ./makeobj pak192
          echo "Created PAK192 Files with all .dat Files"
          break
          ;;
        *) echo "You can ONLY use 64, 96, 128 or 192!"
          ;;
    esac
done


# Check: Is there a SimplePak/PAKs? No? Create One!

if [ -d ~/SimplePak/PAKs ]
  then
    echo "Found SimplePak/PAKs Folder"
  else
    mkdir ~/SimplePak/PAKs
    echo "Created SimplePak/PAKs Folder"
fi


# Move new Files to other PAKs

for paks in *.pak; do
    mv "$paks" "PAKs"
    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
done


# Bye Bye!

echo "=====SIMPLEPAK====="
