#!/bin/sh


# Information

echo "
=====SIMPLEPAK=====
This is a Shell-Script to create PAK Files with MakeObj.
You need makeobj and this Script in the same folder.
=====SIMPLEPAK=====
It's a BETA Version. Updates comming soon. Current Version: 0.2.0
May read the README.txt File for more Informations.
=====SIMPLEPAK=====
"


# Check: Is there makeobj? No? Bad!

while true
  do
    if [ -f makeobj ]
      then
        echo "Found makeobj"
        break
      else
        echo "ERROR: Please download makeobj for Linux!"
        exit 0
    fi
done


# Ask for Pak Size

while true
  do
    read -p "Choose one of these PAK sizes: 64, 96, 128, 192! Enter your PAK size:" pak
    case "$pak" in
        64) ./makeobj pak64
          echo "Created PAK64 Files with all .dat Files"
          break
          ;;
        96) ./makeobj pak96
          echo "Created PAK96 Files with all .dat Files"
          break
          ;;
        128) ./makeobj pak128
          echo "Created PAK128 Files with all .dat Files"
          break
          ;;
        192) ./makeobj pak192
          echo "Created PAK192 Files with all .dat Files"
          break
          ;;
        *) echo "You can ONLY use 64, 96, 128 or 192!"
          ;;
    esac
done


# Check: Is there a SimplePak/PAKs? No? Create One!

if [ -d ~/SimplePak/PAKs ]
  then
    echo "Found SimplePak/PAKs Folder"
  else
    mkdir ~/SimplePak/PAKs
    echo "Created SimplePak/PAKs Folder"
fi

if [ -d ~/SimplePak/PAKs/buildings ]
  then
    echo "Found in SimplePak/PAKs different Folders"
  else
    mkdir ~/SimplePak/PAKs/buildings
    mkdir ~/SimplePak/PAKs/factorys
    mkdir ~/SimplePak/PAKs/field
    mkdir ~/SimplePak/PAKs/vehicles
    mkdir ~/SimplePak/PAKs/citycars
    mkdir ~/SimplePak/PAKs/goods
    mkdir ~/SimplePak/PAKs/tunnels
    mkdir ~/SimplePak/PAKs/bridges
    mkdir ~/SimplePak/PAKs/ways
    mkdir ~/SimplePak/PAKs/way-objects
    mkdir ~/SimplePak/PAKs/roadsigns
    mkdir ~/SimplePak/PAKs/trees
    mkdir ~/SimplePak/PAKs/ground_objs
    echo "Created in SimplePak/PAKs different Folders"
fi


# Move new Files to other PAKs

if [ -e building.*.pak ]
  then
    for paks in building.*.pak; do
        mv "$paks" "PAKs/buildings"
        echo "Moved all created Buildings to /home/<USERNAME>/SimplePak/PAKs/buildings"
    done
  else
    echo "No Buildings created"
fi

if [ -e factory.*.pak ]
  then
    for paks in factory.*.pak; do
        mv "$paks" "PAKs/factorys"
        echo "Moved all created Factorys to /home/<USERNAME>/SimplePak/PAKs/factorys"
    done
  else
    echo "No Factorys created"
fi

if [ -e field.*.pak ]
  then
    for paks in field.*.pak; do
        mv "$paks" "PAKs/fields"
        echo "Moved all created Fields to /home/<USERNAME>/SimplePak/PAKs/fields"
    done
  else
    echo "No Fields created"
fi

if [ -e vehicle.*.pak ]
  then
    for paks in vehicle.*.pak; do
        mv "$paks" "PAKs/vehicles"
        echo "Moved all created Vehicles to /home/<USERNAME>/SimplePak/PAKs/vehicles"
    done
  else
    echo "No Vehicles created"
fi

if [ -e citycar.*.pak ]
  then
    for paks in citycar.*.pak; do
        mv "$paks" "PAKs/citycars"
        echo "Moved all created Citycars to /home/<USERNAME>/SimplePak/PAKs/citycars"
    done
  else
    echo "No Citycars created"
fi

if [ -e good.*.pak ]
  then
    for paks in good.*.pak; do
        mv "$paks" "PAKs/goods"
        echo "Moved all created Goods to /home/<USERNAME>/SimplePak/PAKs/goods"
    done
  else
    echo "No Goods created"
fi

if [ -e tunnel.*.pak ]
  then
    for paks in tunnel.*.pak; do
        mv "$paks" "PAKs/tunnels"
        echo "Moved all created Tunnels to /home/<USERNAME>/SimplePak/PAKs/tunnels"
    done
  else
    echo "No Tunnels created"
fi

if [ -e bridge.*.pak ]
  then
    for paks in bridge.*.pak; do
        mv "$paks" "PAKs/bridges"
        echo "Moved all created Bridges to /home/<USERNAME>/SimplePak/PAKs/bridges"
    done
  else
    echo "No Bridges created"
fi

if [ -e way.*.pak ]
  then
    for paks in way.*.pak; do
        mv "$paks" "PAKs/ways"
        echo "Moved all created Ways to /home/<USERNAME>/SimplePak/PAKs/ways"
    done
  else
    echo "No Ways created"
fi

if [ -e way-objects.*.pak ]
  then
    for paks in way-objects.*.pak; do
        mv "$paks" "PAKs/way-objects"
        echo "Moved all created Way-Objects to /home/<USERNAME>/SimplePak/PAKs/way-objects"
    done
  else
    echo "No Way-Objects created"
fi

if [ -e roadsign.*.pak ]
  then
    for paks in roadsign.*.pak; do
        mv "$paks" "PAKs/roadsigns"
        echo "Moved all created Roadsigns to /home/<USERNAME>/SimplePak/PAKs/roadsigns"
    done
  else
    echo "No Roadsigns created"
fi

if [ -e tree.*.pak ]
  then
    for paks in tree.*.pak; do
        mv "$paks" "PAKs/treets"
        echo "Moved all created Trees to /home/<USERNAME>/SimplePak/PAKs/trees"
    done
  else
    echo "No Trees created"
fi

if [ -e ground_obj.*.pak ]
  then
    for paks in ground_obj.*.pak; do
        mv "$paks" "PAKs/ground_objs"
        echo "Moved all created Ground_Obj's to /home/<USERNAME>/SimplePak/PAKs/ground_objs"
    done
  else
    echo "No Ground_objs created"
fi




#Old!

#for paks in field.*.pak; do
#    mv "$paks" "PAKs/fields"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done

#for paks in vehicle.*.pak; do
#    mv "$paks" "PAKs/vehices"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done

#for paks in citycar.*.pak; do
#    mv "$paks" "PAKs/citycars"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done
#
#for paks in good.*.pak; do
#    mv "$paks" "PAKs/goods"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done
#
#for paks in tunnel.*.pak; do
#    mv "$paks" "PAKs/tunnels"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done
#
#for paks in bridge.*.pak; do
#    mv "$paks" "PAKs/bridges"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done
#
#for paks in way.*.pak; do
#    mv "$paks" "PAKs/ways"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done
#
#for paks in way-objects.*.pak; do
#    mv "$paks" "PAKs/way-objects"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done
#
#for paks in roadsign.*.pak; do
#    mv "$paks" "PAKs/roadsigns"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done
#
#for paks in tree.*.pak; do
#    mv "$paks" "PAKs/trees"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done
#
#for paks in ground_obj.*.pak; do
#    mv "$paks" "PAKs/ground_objs"
#    echo "Moved all created PAK-Files to /home/<USERNAME>/SimplePak/PAKs"
#done



# Bye Bye!

echo "Done
=====SIMPLEPAK====="
