#!/bin/bash
# script for fetching Simutrans translations into CWD
# maintained on dec5:$indep/bin
# note: make sure that you have stored the previous results somewhere else

set -u
case "${1:?Error: enter translation area}"
in pak128)
      version=0
      file=language_pack-pak128.zip
      ;;
   pak64)
      version=1
      file=language_pack-pak64.zip
      ;;
   pak.german)
      version=2
      file=language_pack-pak.german.zip
      ;;
   base)
      version=4
      file=language_pack-Base+texts.zip
      ;;
   *) echo "Error: unknown/unlisted translation area" >&2 ; exit 2
esac
# "-r -l 0" or -N ? We have to switch off -nc, but this is not directly possible.
# -N depends on reliable, synchronized system times
options_replacefile=-N

# The first file is longer, but only because it contains SQL error messages
# - discard it after complete download (although parsing it would give us the archive's name):
wget --post-data "version=${version}&choice=all&submit=Export!" \
--delete-after http://translator.simutrans.com/script/wrap.php \
|| { echo "Error: generating file $file failed (wget returned $?)" >&2; exit 3; }
wget $options_replacefile http://translator.simutrans.com/tmp/"$file" || {
  echo "Error: download of file $file failed (wget returned $?)" >&2
  mv -f "$file" "$file"-defective # may exist
  exit 4
}
unzip -tv "$file" || {
   echo "Error: file $file seems to be defective" >&2
   mv -f "$file" "$file"-defective
   exit 5
}
