#!BPY
""" Registration Info fuer Blender menus:
Name: 'Simutrans Rotator - 1.3'
Blender: 244
Group: 'Object'
Tooltip: 'Creates Render-Views for Simutrans'
"""
__author__ = "Tony Baerenz (TonyBzt)"
__version__ = "1.3"
__bpydoc__ = """\
        hier documentation einfuegen
Version 1.3:
28.05.08/BZT - Umstellung Object wird an Stelle der Lampen etc. rotiert.
	    Parameter YOffset ist obsolete und wird durch Verlängerungsfaktor
	    ersetzt.
	    Handling der Lampen entfernt.
"""


import Blender
from Blender import Mathutils,Scene,Registry
from Blender.Mathutils import *
from Blender.Draw import *
from Blender.BGL import *
from Blender.Object import *

scn = Blender.Scene.GetCurrent()

KachelLaenge = 20
T_AnzahlViews = Create(8)
T_TransOffset = Create(10)
T_YOffset = Create(0)
T_Skalierung = Create(1.3)
nameSun = "Sun"
nameLamp = "LampOnSide"
nameCamera = "MainCamera"
namePlane = "Plane"

obs = [ob for ob in scn.objects if ob.type == 'Lamp' ]
nr = 0
for ob in obs:
    nr = nr + 1
    if nr == 1:
	nameSun = ob.name
    if nr == 2:
	nameLamp = ob.name
obs = [ob for ob in scn.objects if ob.type == 'Camera' ]
nr = 0
for ob in obs:
    nr = nr + 1
    if nr == 1:
	nameCamera = ob.name
obs = [ob for ob in scn.objects if ob.name.startswith('Plane') ]
nr = 0
for ob in obs:
    nr = nr + 1
    if nr == 1:
	namePlane = ob.name


	
T_ObjectSun   = Create(nameSun)
T_ObjectLampOnSide = Create(nameLamp)
T_ObjectPlane = Create(namePlane)
T_ObjectCamera = Create(nameCamera)
# Events
EVENT_NOEVENT = 1
EVENT_DRAW    = 2
EVENT_EXIT    = 3
EVENT_TEST    = 4
EVENT_MOVE    = 5




simuview = []

dict = Blender.Registry.GetKey("simu-views")

if dict:
    try:
        simuview = dict[scn.name]
    except:
        simuview = []

        
def draw():
    global simuview
    global T_AnzahlViews
    global T_TransOffset
    global T_YOffset
    global T_Skalierung
    global T_ObjectSun,T_ObjectLampOnSide,T_ObjectPlane,T_ObjectCamera
    global KachelLaenge,ObjLaenge
    global EVENT_NOEVENT,EVENT_DRAW,EVENT_EXIT,EVENT_TEST,EVENT_MOVE
    
    # Draw backgound as gray
    glClearColor(.6,.6,.6,1)
    #glViewport(0, 0, 300, 140)
    # Titles
    basis = 130
    glClear(GL_COLOR_BUFFER_BIT)
    glColor3f(0.10,0.10,0.80)
    glRasterPos2d(8,basis)
    Text("Create Simutrans Views")
    
    # Parameter GUI-Buttons
    glRasterPos2d(8,basis-20)
    Text("Parameters:")
    T_AnzahlViews = Number("Anzahl Frames:",EVENT_NOEVENT, 10,basis-90, 210, 18,
                           T_AnzahlViews.val,2,8,"Anzahl Views fuer Simutrans-Object")

    T_TransOffset = Number("Laenge-Objekt:",EVENT_NOEVENT,10,basis-70,210,18,
			   T_TransOffset.val,1,16,"Laenge des Objekts (1-16,10)")
    
    T_Skalierung = Number("Skalierung:",EVENT_NOEVENT,10,basis-50,210,18,
		        T_Skalierung.val,1,1.41,"Skalierung fuer Horizontal/Vertikal")
    if 1 == 0:
        T_ObjectSun   = String("Name Sun-Lampe:",EVENT_TEST, 10,60, 210, 18, T_ObjectSun.val, 20,
                               "Name der Sun-Lampe")  
        T_ObjectLampOnSide   = String("Name Lampe:",EVENT_TEST, 10,80, 210, 18, T_ObjectLampOnSide.val, 20,
                               "Name der (Hilfs-)Lampe")  
        T_ObjectPlane   = String("Name Plane:",EVENT_TEST, 10,100, 210, 18, T_ObjectPlane.val, 20,
                                  "Name des Undergrunds")  

        T_ObjectCamera   = String("Name Camera:",EVENT_TEST, 10,120, 210, 18, T_ObjectCamera.val, 20,
                                  "Name der Haupt-Camera")  
     
 
 
    # Draw and Exit Buttons
    butpos = 10
    Button("Move",EVENT_MOVE , butpos, basis-120, 80, 18)
    butpos += 110
    if 1 == 0:
        Button("Draw",EVENT_DRAW, butpos, basis-120, 80, 18)
        butpos += 110
        
    Button("Exit",EVENT_EXIT , butpos, basis-120, 80, 18)
    butpos += 110


def event(evt, val):	
    if (evt == QKEY and not val): 
	Exit()
 
def bevent(evt):
    global T_AnzahlViews
    global T_TransOffset,T_YOffset,T_Skalierung
    global T_ObjectSun,T_ObjectLampOnSide,T_ObjectPlane,T_ObjectCamera
    global KachelLaenge
    global EVENT_NOEVENT,EVENT_DRAW,EVENT_EXIT,EVENT_TEST,EVENT_MOVE
    global scn
    
    # Manages GUI events
    if (evt == EVENT_EXIT): 
	Exit()
    elif (evt== EVENT_DRAW):
	if not ExistAll():
	    return
	ListObjects = []
	ListObjects.append(T_ObjectSun.val)
	ListObjects.append(T_ObjectLampOnSide.val)
	ListObjects.append(T_ObjectPlane.val)
	ListObjects.append(T_ObjectCamera.val)
	
	CreateSimuViews(T_AnzahlViews.val,T_TransOffset.val,ListObjects,T_YOffset.val)
	Blender.Redraw()
	Exit()
    elif (evt== EVENT_MOVE):
	
	if MoveSimuViews(T_AnzahlViews.val,T_TransOffset.val,T_Skalierung.val) == 0:
            Blender.Redraw()
            Exit()
        else:
            smsg = "Bitte Frame auf 1 stellen"
            Text(smsg)
            return 0
	Exit()
    elif (evt == EVENT_TEST):
	return ExistAll()
	    
	
Register(draw, event, bevent)



def ExistAll():
    global T_ObjectSun,T_ObjectLampOnSide,T_ObjectPlane,T_ObjectCamera
    true = 1
    false = 0
    
    ok = true    
    if not ExistObject( T_ObjectSun.val ):
	smsg = "Sun-Lampe ",T_ObjectSun.val," existiert nicht"
	Text(smsg,"large")
	ok = false
    if not ExistObject( T_ObjectLampOnSide.val ):
	smsg = "Lampe ",T_ObjectLampOnSide.val," existiert nicht"
	Text(smsg,"large")
	ok = false
    if not ExistObject( T_ObjectPlane.val ):
	smsg = "Plane ",T_ObjectPlane.val," existiert nicht"
	Text(smsg,"large")
	ok = false
    if not ExistObject( T_ObjectCamera.val ):
	smsg = "Camera ",T_ObjectCamera.val," existiert nicht"
	Text(smsg,"large")
	ok = false
    return ok



          
def ExistObject( name ):
    global scn
    list = []
    print "name=",name
    list.append(name)
    obs = []
    obs = [ob for ob in scn.objects if ob.name in list ]
    return (len(obs) > 0)




def CreateSimuViews(nAnzahlFrames,nOffset,listSelect,nYoffset):

    global KachelLaenge
    print "listSelect=",listSelect
    #nBase = -nOffset
    # Ab Version 1.2:
    # nOffset ist die Länge des Objekts in Werten von 1 bis 16 (max.Kachelgroesse in Simutrans)
    KachelLaenge1 = KachelLaenge  - 2    # Kachellänge 18 Verwenden
    nOffset1 = nOffset * KachelLaenge1 / 16
    nOffsetMitte = ( KachelLaenge1 - nOffset1 ) / 2 
    nOffsetSeite = KachelLaenge1 - nOffset1 - 2  # Testen
    print "nOffsetMitte=", nOffsetMitte
    print "nOffsetSeite=", nOffsetSeite
    #nBase = nOffset - 8
    scn = Blender.Scene.GetCurrent()      # get the current scene
    # Es werden alle Object geholt die gedreht werden sollen.
    # Bedingung: Die Namen muessen entsprechend vorgegeben werden.
    # Die Lampen: Sun und LampSide
    # Das Tile: PlaneTile
    # Der Template-"Kaefig": CubeTemplate
    #
    # Jeder Sicht wird durch Rotation und Translation erzeugt.
    translat = [ [0.,0.,0.],[ 0.,0.,0.],[-nOffsetMitte,-nYoffset/10,0.],[-nOffsetMitte,0.,0.],
		 [-nOffsetSeite,0.,0.],[-nOffsetSeite,0.,0.],[-nOffsetMitte,nYoffset/10,0.],[-nOffsetMitte,0.,0.] ]
    if 1 == 0:
	translat = [ [0.,0.,0.],[ 0.,0.,0.],[nOffsetMitte,-nYoffset/10,0.],[nOffsetMitte,0.,0.],
		     [nOffsetSeite,0.,0.],[nOffsetSeite,0.,0.],[nOffsetMitte,nYoffset/10,0.],[nOffsetMitte,0.,0.] ]
    rotwinkel = [ 0, -90, 45, +90, 135, -90, 45, 90 ]
    framelist = [1,2,3,4,5,6,7,8]
    if nAnzahlFrames <= 4:
	rotwinkel = [0,90,180,270]
	translat = [ [0.,0.,0.],[0.,0.,0.],[0.,0.,0.],[0.,0.,0.]]
        framelist = [1,2,3,4]
    if nAnzahlFrames <= 2:
	framelist = [1,2]
	
    print "nAnzahlFrames=",nAnzahlFrames
    print "rotwinkel=",rotwinkel
    print "translat=",translat
    
    #  frame      --1--                                                   --8--
    #LampSun = Blender.Object.Get("Sun")
    #LampOnSide = Blender.Object.Get("LampOnSide")
    #PlaneTile = Blender.Object.Get("PlaneTile")
    #Muster = Blender.Object.Get("CubeTemplate")
    #Camera = Blender.Object.Get("MainCamera")
    #
    # Rotation durchfuehren
    #  Rotationsmatrix um x=0,y=0,z0
    
    scn = Scene.GetCurrent()
    
    context = scn.getRenderingContext()
    frame = context.currentFrame()
    print "frame=",frame
    
    # if frame <> 1, then set frame to 1.
    #listSelect = [ "Sun","LampOnSide","PlaneTile","MainCamera"]
    ruecktrans = [0,0,0]
    lastscale = 0
    #framelist = [1,2,3,4,5,6,7,8]
    #framelist = [1,2,3,4,5,6,7,8]
    if frame == 1:
	for frame in range(1,nAnzahlFrames+1):
	    context.currentFrame(frame);
	    # Bestimme Translation für frame
	    vec = Vector(translat[frame-1])
	    print "frame=",frame,vec             
	    transmat = TranslationMatrix( vec )
	    rotmat = RotationMatrix(rotwinkel[frame-1],4,"z")
	    
	    print "transmat=",transmat
	    print "rotmat=",rotmat
	    
	    # get a list of mesh objects
	    obs = [ob for ob in scn.objects if ob.name in listSelect ]
	    scn.objects.selected = []        
	    scn.objects.selected = obs # select 
	    # Wenn zuvor eine Translation war, dann muss jetzt zurückgesetzt werden.
	    rueckmat = TranslationMatrix(Vector(ruecktrans))
	    for ob in obs:
		mat = ob.getMatrix()
		mat = mat * rueckmat
		ob.setMatrix(mat)
		
	    rotlat = rotmat * transmat
	    
	    for ob in obs:
		mat = ob.getMatrix()
		mat = mat * rotlat
		ob.setMatrix(mat)
    
	    Blender.Redraw()    
	    ruecktrans = translat[frame-1]
	    ruecktrans = [ -ruecktrans[0],-ruecktrans[1],-ruecktrans[2] ]
	    for ob in obs:
		ob.insertIpoKey(Blender.Object.IpoKeyTypes.LOCROTSIZE)
		    
        Blender.Redraw()
        return 0
    else:
        return frame-1
	
def ScaleMatx(faktor):
    mat = ScaleMatrix(faktor,4)
    mat[1][1] = 1.
    mat[2][2] = 1.
    mat[3][3] = 1. 
    #print "ScaleMatx mat=",mat
    return mat

def MoveSimuViews(nAnzahlFrames,nOffset,nHorizSkala):

    global KachelLaenge
    #print "listSelect=",listSelect
    #nBase = -nOffset
    # Ab Version 1.2:
    # nOffset ist die Länge des Objekts in Werten von 1 bis 16 (max.Kachelgroesse in Simutrans)
    KachelLaenge1 = KachelLaenge  - 2    # Kachellänge 18 Verwenden
    nOffset1 = nOffset * KachelLaenge1 / 16
    nOffsetMitte = ( KachelLaenge1 - nOffset1 ) / 2 
    nOffsetSeite = KachelLaenge1 - nOffset1 - 2  # Testen
    print "nOffsetMitte=", nOffsetMitte
    print "nOffsetSeite=", nOffsetSeite
    #nBase = nOffset - 8
    scn = Blender.Scene.GetCurrent()      # get the current scene
    # Es werden alle Object geholt die gedreht werden sollen.
    # Bedingung: Die Namen muessen entsprechend vorgegeben werden.
    # Die Lampen: Sun und LampSide
    # Das Tile: PlaneTile
    # Der Template-"Kaefig": CubeTemplate
    #
    # Jeder Sicht wird durch Rotation und Translation erzeugt.
    #translat = [ [0.,0.,0.],[ 0.,0.,0.],[+nOffsetMitte,nYoffset/10,0.],[nOffsetMitte,0.,0.],
    #		 [-nOffsetSeite,0.,0.],[-nOffsetSeite,0.,0.],[-nOffsetMitte,nYoffset/10,0.],[-nOffsetMitte,0.,0.] ]
    translat = [ [0.,0.,0.],[ 0.,0.,0.],[0.,0.,0.],[nOffsetMitte,-nOffsetMitte,0.],
		 [-nOffsetSeite,0.,0.],[0.,-nOffsetSeite,0.],[-nOffsetSeite,-nOffsetSeite,0.],[(-nOffsetSeite+nOffsetMitte)*nHorizSkala,(nOffsetSeite-nOffsetMitte)*nHorizSkala,0.] ]
    #rotwinkel = [ 0, -90, 45, +90, 135, -90, 45, 90 ]
    rotwinkel = [ 0, 90, -45, -90, -135, 90, -45, -90 ]
    scalierung = [ 1., 1., nHorizSkala, nHorizSkala, 1., 1., nHorizSkala, nHorizSkala ]
    framelist = [1,2,3,4,5,6,7,8]
    if nAnzahlFrames <= 4:
	rotwinkel = [0,90,180,270]
	translat = [ [0.,0.,0.],[0.,0.,0.],[0.,0.,0.],[0.,0.,0.]]
	scalierung = [ 1.,1.,1.,1.,1.,1.,1.,1.]
        framelist = [1,2,3,4]
    if nAnzahlFrames <= 2:
	framelist = [1,2]

    #scalierung = [ 1.,1.,1.,1.,1.,1.,1.,1.]
    print "nAnzahlFrames=",nAnzahlFrames
    print "rotwinkel=",rotwinkel
    print "translat=",translat
    
    #  frame      --1--                                                   --8--
    #LampSun = Blender.Object.Get("Sun")
    #LampOnSide = Blender.Object.Get("LampOnSide")
    #PlaneTile = Blender.Object.Get("PlaneTile")
    #Muster = Blender.Object.Get("CubeTemplate")
    #Camera = Blender.Object.Get("MainCamera")
    #
    # Rotation durchfuehren
    #  Rotationsmatrix um x=0,y=0,z0
    
    #scn = Scene.GetCurrent()
    oldSelected = scn.objects.selected
    obs = [ob for ob in scn.objects.selected if ob.type == "Mesh" ]
    scn.objects.selected = obs
    context = scn.getRenderingContext()
    frame = context.currentFrame()
    print "frame=",frame
    if frame > 1:
        frame = 1
        context.currentFrame(frame)
        frame = context.currentFrame()
        print "frame changed",frame
    #listSelect = [ "Sun","LampOnSide","PlaneTile","MainCamera"]
    ruecktrans = [0,0,0]
    winkelsum = 0
    rueckscale = 1.0
    lastscale = 0
    #framelist = [1,2,3,4,5,6,7,8]
    #framelist = [1,2,3,4,5,6,7,8]
    if frame == 1:
	oldSelected = scn.objects.selected
	obs = [ob for ob in scn.objects.selected if ob.type == "Mesh" ]
	scn.objects.selected = obs
	for frame in range(1,nAnzahlFrames+1):
	    context.currentFrame(frame);
	    # Bestimme Translation für frame
	    vec = Vector(translat[frame-1])
	    print "frame=",frame,vec             
	    transmat = TranslationMatrix( vec )
	    rotvorher = RotationMatrix(-winkelsum,4,"z")
	    winkelsum += rotwinkel[frame-1]
	    rotmat = RotationMatrix(winkelsum,4,"z")
	    
	    print "transmat=",transmat
	    print "rotmat=",rotmat
	    print "winkelsum=",winkelsum
	    
	    # Wenn zuvor eine Translation war, dann muss jetzt zurückgesetzt werden.
	    
	    rueckmat = TranslationMatrix(Vector(ruecktrans))
	    for ob in obs:
		mat = ob.getMatrix()
		mat = mat * rueckmat
		ob.setMatrix(mat)
	
	    # Zurückdrehen auf Winkel 0 
	    for ob in obs:
		mat = ob.getMatrix()
		mat = mat * rotvorher
		ob.setMatrix(mat)
	    
	    # Scalierung zurücknehmen
	    scalemat = ScaleMatx(rueckscale)
	    for ob in obs:
		mat = ob.getMatrix()
		mat = mat * scalemat
		ob.setMatrix(mat)
	    
	    scalemat = ScaleMatx( scalierung[frame-1])
	    print "scalemat=",scalemat
	    rueckscale = 1 / scalierung[frame-1] 
	    rotlat = scalemat * rotmat * transmat 
	    
	    for ob in obs:
		mat = ob.getMatrix()
		mat = mat * rotlat
		ob.setMatrix(mat)
    
	    Blender.Redraw()    
	    ruecktrans = translat[frame-1]
	    ruecktrans = [ -ruecktrans[0],-ruecktrans[1],-ruecktrans[2] ]
	    for ob in obs:
		ob.insertIpoKey(Blender.Object.IpoKeyTypes.LOCROTSIZE)
	#scn.objects.selected = oldSelected	    
        Blender.Redraw()
        return 0
    else:
        return frame-1
    
